<?php
/**
 * The Classic template for displaying content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

$windsor_blog_style = explode('_', windsor_get_theme_option('blog_style'));
$windsor_columns = empty($windsor_blog_style[1]) ? 2 : max(2, $windsor_blog_style[1]);
$windsor_expanded = !windsor_sidebar_present() && windsor_is_on(windsor_get_theme_option('expand_content'));
$windsor_post_format = get_post_format();
$windsor_post_format = empty($windsor_post_format) ? 'standard' : str_replace('post-format-', '', $windsor_post_format);
$windsor_animation = windsor_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($windsor_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_classic post_layout_classic_'.esc_attr($windsor_columns).' post_format_'.esc_attr($windsor_post_format) ); ?>
	<?php echo (!windsor_is_off($windsor_animation) ? ' data-animation="'.esc_attr(windsor_get_animation_classes($windsor_animation)).'"' : ''); ?>
	>

	<?php

	// Featured image
	windsor_show_post_featured( array( 'thumb_size' => windsor_get_thumb_size(
													strpos(windsor_get_theme_option('body_style'), 'full')!==false 
														? ( $windsor_columns > 2 ? 'big' : 'huge' )
														: (	$windsor_columns > 2
															? ($windsor_expanded ? 'med' : 'small')
															: ($windsor_expanded ? 'big' : 'med')
															)
														)
										) );

	if ( !in_array($windsor_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
			// Post meta
			windsor_show_post_meta(array(
				'categories' => true,
				'date' => true,
				'edit' => $windsor_columns < 3,
				'seo' => false,
				'share' => false,
				'counters' => 'comments',
				)
			);
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$windsor_show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($windsor_post_format, array('link', 'aside', 'status', 'quote'))) {
				the_content();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($windsor_post_format, array('link', 'aside', 'status', 'quote'))) {
			windsor_show_post_meta(array(
				'share' => false,
				'counters' => 'comments'
				)
			);
		}
		// More button
		if ( $windsor_show_learn_more ) {
			?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'windsor'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>