<?php
/**
 * The Sticky template for displaying sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

$windsor_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$windsor_post_format = get_post_format();
$windsor_post_format = empty($windsor_post_format) ? 'standard' : str_replace('post-format-', '', $windsor_post_format);
$windsor_animation = windsor_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($windsor_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($windsor_post_format) ); ?>
	<?php echo (!windsor_is_off($windsor_animation) ? ' data-animation="'.esc_attr(windsor_get_animation_classes($windsor_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	windsor_show_post_featured(array(
		'thumb_size' => windsor_get_thumb_size($windsor_columns==1 ? 'big' : ($windsor_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($windsor_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			windsor_show_post_meta();
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>