<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

windsor_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	?><div class="posts_container"><?php
	
	$windsor_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$windsor_sticky_out = is_array($windsor_stickies) && count($windsor_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($windsor_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	while ( have_posts() ) { the_post(); 
		if ($windsor_sticky_out && !is_sticky()) {
			$windsor_sticky_out = false;
			?></div><?php
		}
		get_template_part( 'content', $windsor_sticky_out && is_sticky() ? 'sticky' : 'excerpt' );
	}
	if ($windsor_sticky_out) {
		$windsor_sticky_out = false;
		?></div><?php
	}
	
	?></div><?php

	windsor_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>