<?php
/* elegro Crypto Payment support functions
------------------------------------------------------------------------------- */
// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'windsor_elegro_payment_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'windsor_elegro_payment_theme_setup9', 9 );
	function windsor_elegro_payment_theme_setup9() {
		if ( windsor_exists_elegro_payment() ) {
            add_action('wp_enqueue_scripts', 'windsor_elegro_payment_frontend_scripts', 1100);
			add_filter( 'windsor_filter_merge_styles', 'windsor_elegro_payment_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'windsor_filter_tgmpa_required_plugins', 'windsor_elegro_payment_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'windsor_elegro_payment_tgmpa_required_plugins' ) ) {
	function windsor_elegro_payment_tgmpa_required_plugins( $list = array() ) {
            if (in_array('elegro-payment', windsor_storage_get('required_plugins'))) {
			$list[] = array(
                'name' 		=> esc_html__('elegro Crypto Payment', 'windsor'),
				'slug'     => 'elegro-payment',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if this plugin installed and activated
if ( ! function_exists( 'windsor_exists_elegro_payment' ) ) {
	function windsor_exists_elegro_payment() {
		return class_exists( 'WC_Elegro_Payment' );
	}
}

// Merge custom styles
if ( ! function_exists( 'windsor_elegro_payment_merge_styles' ) ) {
	function windsor_elegro_payment_merge_styles( $list ) {
		$list[] = 'css/plugin.elegro-payment.css';
		return $list;
	}
}
// Enqueue custom styles
if (!function_exists('windsor_elegro_payment_frontend_scripts')) {
    function windsor_elegro_payment_frontend_scripts()
    {
        if (windsor_exists_elegro_payment()) {
            if (windsor_is_on(windsor_get_theme_option('debug_mode')) && windsor_get_file_dir('css/plugin.elegro-payment.css') != '')
                wp_enqueue_style('windsor-elegro-payment', windsor_get_file_url('css/plugin.elegro-payment.css'), array(), null);
        }
    }
}