<?php
/* Tribe Events Calendar support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
if (!function_exists('windsor_tribe_events_theme_setup1')) {
	add_action( 'after_setup_theme', 'windsor_tribe_events_theme_setup1', 1 );
	function windsor_tribe_events_theme_setup1() {
		add_filter( 'windsor_filter_list_sidebars', 'windsor_tribe_events_list_sidebars' );
	}
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if (!function_exists('windsor_tribe_events_theme_setup3')) {
	add_action( 'after_setup_theme', 'windsor_tribe_events_theme_setup3', 3 );
	function windsor_tribe_events_theme_setup3() {
		if (windsor_exists_tribe_events()) {
			windsor_storage_merge_array('options', '', array(
				// Section 'Tribe Events' - settings for show pages
				'events' => array(
					"title" => esc_html__('Events', 'windsor'),
					"desc" => wp_kses_data( __('Select parameters to display the events pages', 'windsor') ),
					"type" => "section"
					),
				'expand_content_events' => array(
					"title" => esc_html__('Expand content', 'windsor'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'windsor') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
				'header_widgets_events' => array(
					"title" => esc_html__('Header widgets', 'windsor'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on the events pages', 'windsor') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
					"type" => "select"
					),
				'sidebar_widgets_events' => array(
					"title" => esc_html__('Sidebar widgets', 'windsor'),
					"desc" => wp_kses_data( __('Select sidebar to show on the events pages', 'windsor') ),
					"std" => 'tribe_events_widgets',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
					"type" => "select"
					),
				'sidebar_position_events' => array(
					"title" => esc_html__('Sidebar position', 'windsor'),
					"desc" => wp_kses_data( __('Select position to show sidebar on the events pages', 'windsor') ),
					"refresh" => false,
					"std" => 'left',
					"options" => windsor_get_list_sidebars_positions(),
					"type" => "select"
					),
				'widgets_above_page_events' => array(
					"title" => esc_html__('Widgets above the page', 'windsor'),
					"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'windsor') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_above_content_events' => array(
					"title" => esc_html__('Widgets above the content', 'windsor'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'windsor') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_below_content_events' => array(
					"title" => esc_html__('Widgets below the content', 'windsor'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'windsor') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_below_page_events' => array(
					"title" => esc_html__('Widgets below the page', 'windsor'),
					"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'windsor') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
					"type" => "select"
					),
				'footer_scheme_events' => array(
					"title" => esc_html__('Footer Color Scheme', 'windsor'),
					"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'windsor') ),
					"std" => 'dark',
					"options" => windsor_get_list_schemes(true),
					"type" => "select"
					),
				'footer_widgets_events' => array(
					"title" => esc_html__('Footer widgets', 'windsor'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'windsor') ),
					"std" => 'footer_widgets',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
					"type" => "select"
					),
				'footer_columns_events' => array(
					"title" => esc_html__('Footer columns', 'windsor'),
					"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'windsor') ),
					"dependency" => array(
						'footer_widgets_events' => array('^hide')
					),
					"std" => 0,
					"options" => windsor_get_list_range(0,6),
					"type" => "select"
					),
				'footer_wide_events' => array(
					"title" => esc_html__('Footer fullwide', 'windsor'),
					"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'windsor') ),
					"std" => 0,
					"type" => "checkbox"
					)
				)
			);
		}
	}
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('windsor_tribe_events_theme_setup9')) {
	add_action( 'after_setup_theme', 'windsor_tribe_events_theme_setup9', 9 );
	function windsor_tribe_events_theme_setup9() {
		
		if (windsor_exists_tribe_events()) {
			add_action( 'wp_enqueue_scripts', 										'windsor_tribe_events_frontend_scripts', 1100 );
			add_filter( 'windsor_filter_merge_styles',						'windsor_tribe_events_merge_styles' );
			add_filter( 'windsor_filter_get_css',							'windsor_tribe_events_get_css', 10, 3 );
			if (!is_admin()) {
				add_filter( 'windsor_filter_detect_blog_mode',				'windsor_tribe_events_detect_blog_mode' );
				add_filter( 'windsor_filter_post_type_taxonomy',			'windsor_tribe_events_post_type_taxonomy', 10, 2 );
				add_filter( 'windsor_filter_get_blog_all_posts_link', 		'windsor_tribe_events_get_blog_all_posts_link');
				add_filter( 'windsor_filter_get_blog_title', 				'windsor_tribe_events_get_blog_title');
				add_filter( 'windsor_filter_need_page_title', 				'windsor_tribe_events_need_page_title');
				add_filter( 'windsor_filter_get_post_categories', 			'windsor_tribe_events_get_post_categories');
				add_filter( 'windsor_filter_get_post_date',		 			'windsor_tribe_events_get_post_date');
			} else {
				add_filter( 'admin_enqueue_scripts',			 			'windsor_tribe_events_admin_scripts');
			}
		}
		if (is_admin()) {
			add_filter( 'windsor_filter_tgmpa_required_plugins',			'windsor_tribe_events_tgmpa_required_plugins' );
		}

	}
}



// Check if Tribe Events is installed and activated
if ( !function_exists( 'windsor_exists_tribe_events' ) ) {
	function windsor_exists_tribe_events() {
		return class_exists( 'Tribe__Events__Main' );
	}
}

// Return true, if current page is any tribe_events page
if ( !function_exists( 'windsor_is_tribe_events_page' ) ) {
	function windsor_is_tribe_events_page() {
		$rez = false;
		if (windsor_exists_tribe_events())
			if (!is_search()) $rez = tribe_is_event() || tribe_is_event_query() || tribe_is_event_category() || tribe_is_event_venue() || tribe_is_event_organizer();
		return $rez;
	}
}

// Detect current blog mode
if ( !function_exists( 'windsor_tribe_events_detect_blog_mode' ) ) {
	
	function windsor_tribe_events_detect_blog_mode($mode='') {
		if (windsor_is_tribe_events_page())
			$mode = 'events';
		return $mode;
	}
}

// Return taxonomy for current post type
if ( !function_exists( 'windsor_tribe_events_post_type_taxonomy' ) ) {
	
	function windsor_tribe_events_post_type_taxonomy($tax='', $post_type='') {
		if (windsor_exists_tribe_events() && $post_type == Tribe__Events__Main::POSTTYPE)
			$tax = Tribe__Events__Main::TAXONOMY;
		return $tax;
	}
}

// Return current page title
if ( !function_exists( 'windsor_tribe_events_get_blog_title' ) ) {
	
	function windsor_tribe_events_get_blog_title($title='') {
		if (windsor_is_tribe_events_page() ) {
			if (is_archive())
				$title = apply_filters( 'tribe_events_title', tribe_get_events_title( false ) );
			else {
				global $wp_query;
                if (!empty($wp_query->queried_object)) {
                    $title = $wp_query->queried_object->post_title;
                }
			}
		}
		return $title;
	}
}



// Return link to the main events page for the breadcrumbs
if ( !function_exists( 'windsor_tribe_events_get_blog_all_posts_link' ) ) {
	
	function windsor_tribe_events_get_blog_all_posts_link($link='') {
		if ($link=='' && windsor_is_tribe_events_page() && (!is_archive() || tribe_is_event_category()))
			$link = '<a href="'.esc_url(tribe_get_events_link()).'">'.esc_html__('Events', 'windsor').'</a>';
		return $link;
	}
}

// Detect if page title must be showed
if ( !function_exists( 'windsor_tribe_events_show_page_title' ) ) {
	
	function windsor_tribe_events_need_page_title($need=false) {
		if (!$need)
			$need = windsor_is_tribe_events_page();
		return $need;
	}
}

// Show categories of the current event
if ( !function_exists( 'windsor_tribe_events_get_post_categories' ) ) {
	
	function windsor_tribe_events_get_post_categories($cats='') {
		if (get_post_type()==Tribe__Events__Main::POSTTYPE) {
			$cats = windsor_get_post_terms(', ', get_the_ID(), Tribe__Events__Main::TAXONOMY);
		}
		return $cats;
	}
}

// Return date of the current event
if ( !function_exists( 'windsor_tribe_events_get_post_date' ) ) {
	
	function windsor_tribe_events_get_post_date($dt='') {
		if (get_post_type()==Tribe__Events__Main::POSTTYPE) {
			$dt = tribe_get_start_date(null, true, 'Y-m-d');
			$dt = sprintf($dt < date('Y-m-d') 
								? esc_html__('Started on %s', 'windsor') 
								: esc_html__('Starting %s', 'windsor'),
								date(get_option('date_format'), strtotime($dt)));
		}
		return $dt;
	}
}
	
// Enqueue Tribe Events custom styles
if ( !function_exists( 'windsor_tribe_events_frontend_scripts' ) ) {
	
	function windsor_tribe_events_frontend_scripts() {
		if (windsor_is_tribe_events_page()) {
			if (windsor_is_on(windsor_get_theme_option('debug_mode')) && file_exists(windsor_get_file_dir('css/plugin.the-events-calendar.css')))
                wp_enqueue_style( 'the-events-calendar',  windsor_get_file_url('css/plugin.the-events-calendar.css'), array(), null );
		}
	}
}
	
// Enqueue Tribe Events admin scripts
if ( !function_exists( 'windsor_tribe_events_admin_scripts' ) ) {
	
	function windsor_tribe_events_admin_scripts() {
		wp_deregister_style('tribe-jquery-ui-theme');
	}
}
	
// Merge custom styles
if ( !function_exists( 'windsor_tribe_events_merge_styles' ) ) {
	
	function windsor_tribe_events_merge_styles($list) {
		$list[] = 'css/plugin.the-events-calendar.css';
		return $list;
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'windsor_tribe_events_tgmpa_required_plugins' ) ) {
	
	function windsor_tribe_events_tgmpa_required_plugins($list=array()) {
		if (in_array('the-events-calendar', windsor_storage_get('required_plugins')))
			$list[] = array(
					'name' 		=> esc_html__('Tribe Events Calendar', 'windsor'),
					'slug' 		=> 'the-events-calendar',
					'required' 	=> false
				);
		return $list;
	}
}



// Add Tribe Events specific items into lists
//------------------------------------------------------------------------

// Add sidebar
if ( !function_exists( 'windsor_tribe_events_list_sidebars' ) ) {
	
	function windsor_tribe_events_list_sidebars($list=array()) {
		$list['tribe_events_widgets'] = esc_html__('Tribe Events Widgets', 'windsor');
		return $list;
	}
}



// Add Tribe Events specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'windsor_tribe_events_get_css' ) ) {
	
	function windsor_tribe_events_get_css($css, $colors, $fonts) {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS
			
.tribe-events-list .tribe-events-list-event-title {
	font-family: {$fonts['h3']['family']};
}

.tribe-events-calendar-month__header-column-title.tribe-common-b3, 
.tribe-common .tribe-common-b3, 
.tribe-events .tribe-events-c-ical__link, 
.tribe-common .tribe-common-c-btn-border, 
.tribe-common a.tribe-common-c-btn-border,
 body .tribe-events .tribe-events-c-top-bar__datepicker-button, 
 .tribe-common .tribe-common-c-btn,
 .tribe-events .tribe-events-c-view-selector__list-item-text,

.tribe-events-list .tribe-events-list-separator-month,
.tribe-events-calendar thead th,
.tribe-events-schedule, .tribe-events-schedule h2,
.tribe-events-read-more,
#tribe-events .tribe-events-button, .tribe-events-button, .tribe-events-cal-links a, .tribe-events-sub-nav li a,
.tribe-events .datepicker .datepicker-switch,
#tribe-bar-form button, #tribe-bar-form a,
.tribe-events .tribe-events-calendar-month__day-date,
.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.tribe-common .tribe-common-h5, .tribe-common .tribe-common-h6,
.tribe-common .tribe-common-h7, .tribe-common .tribe-common-h8{
	font-family: {$fonts['h5']['family']};
}
#tribe-bar-form input, #tribe-events-content.tribe-events-month,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title,
#tribe-mobile-container .type-tribe_events,
.tribe-events .datepicker .day, .tribe-events .datepicker .dow,
.tribe-events-list-widget ol li .tribe-event-title,
.tribe-events .datepicker .month, .tribe-events .datepicker .year,
.tribe-common .tribe-common-c-btn-border-small, .tribe-common a.tribe-common-c-btn-border-small,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-description,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-form-control-text__input, 
.tribe-common .tribe-common-form-control-text__input,
.tribe-events-calendar-list__event-venue.tribe-common-b2,
.tribe-common .tribe-common-b2 .tribe-events-c-messages__message-list-item,
.tribe-common .tribe-events-calendar-day__event-description.tribe-common-b2,
.tribe-common .tribe-events-calendar-day__event-venue.tribe-common-b2,
.tribe-events-calendar-month__calendar-event-tooltip-description.tribe-common-b3,
.tribe-common .tribe-events-calendar-month__multiday-event-bar-title.tribe-common-h8,
.tribe-common .tribe-events-calendar-month__multiday-event-hidden-title.tribe-common-h8,
.tribe-events-calendar-month__multiday-event-bar h3 {
	font-family: {$fonts['p']['family']};
}
.tribe-events-loop .tribe-event-schedule-details,
.single-tribe_events #tribe-events-content .tribe-events-event-meta dt,
#tribe-mobile-container .type-tribe_events .tribe-event-date-start,
.tribe-common .tribe-events-c-nav__list-item .tribe-common-b2,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-events .tribe-events-calendar-day__event-datetime-wrapper.tribe-common-b2,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-datetime-wrapper {
	font-family: {$fonts['info']['family']};
}

CSS;
		}

		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

/* Buttons */
#tribe-bar-views-toggle,
.tribe-common .tribe-events-c-search .tribe-events-c-search__button,
.tribe-events .tribe-events-c-ical__link,
#tribe-bar-form .tribe-bar-submit input[type="submit"],
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"],
#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
#tribe-bar-views-toggle:hover,
.tribe-common .tribe-events-c-search .tribe-events-c-search__button:hover,
.tribe-events .tribe-events-c-ical__link:hover,
#tribe-bar-form .tribe-bar-submit input[type="submit"]:hover,
#tribe-bar-form .tribe-bar-submit input[type="submit"]:focus,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:focus,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:focus,
#tribe-events .tribe-events-button:hover,
.tribe-events-button:hover,
.tribe-events-cal-links a:hover,
.tribe-events-sub-nav li a:hover {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
.tribe-events .datepicker .day.active,
.tribe-events .tribe-events-c-view-selector__button:before,
.tribe-events .tribe-events-calendar-month__mobile-events-icon--event,
.tribe-events .datepicker .month.active, .tribe-events .datepicker .month.active.focused,
.tribe-events .datepicker .year.active, .tribe-events .datepicker .year.active.focused,
.tribe-events .tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__mobile-events-icon--event,
.tribe-common .tribe-common-c-loader__dot{
	background-color: {$colors['text_link']};
} 
.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner {
	background-color: {$colors['inverse_light']};
}
.tribe-events-calendar-month__multiday-event-bar h3{
	color: {$colors['text_dark']};
}
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date,
.tribe-events .tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__day-date,
.tribe-common .tribe-events-c-top-bar button.tribe-common-h3,
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link{
    color: {$colors['text_link']};
}
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link:hover{
    color: {$colors['text_dark']};
}
.tribe-common .tribe-events-c-top-bar button.tribe-common-h3:hover{
 color: {$colors['text_hover']}!important;
}


/* Filters bar */
#tribe-bar-form {
	color: {$colors['text_dark']};
}
#tribe-bar-form input[type="text"] {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}

#tribe-bar-views li.tribe-bar-views-option a,
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a {
	color: {$colors['inverse_text']};
	background: {$colors['text_link']};
}
#tribe-bar-views li.tribe-bar-views-option a:hover,
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a:hover {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']};
}
.datepicker thead tr:first-child th:hover, .datepicker tfoot tr th:hover {
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}

/* Content */
.tribe-events-calendar thead th {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']} !important;
	border-color: {$colors['text_dark']} !important;
}
.tribe-events-calendar thead th + th:before {
	background: {$colors['bg_color']};
}
#tribe-events-content .tribe-events-calendar td {
	border-color: {$colors['bd_color']} !important;
}
.tribe-events-calendar td div[id*="tribe-events-daynum-"],
.tribe-events-calendar td div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_dark']};
}
.tribe-events-calendar td.tribe-events-othermonth {
	color: {$colors['alter_light']};
	background: {$colors['alter_bg_color']} !important;
}
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"] > a {
	color: {$colors['alter_light']};
}
.tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"], .tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_light']};
}
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_link']};
}
.tribe-events-calendar td.tribe-events-present:before {
	border-color: {$colors['text_link']};
}
.tribe-events-calendar .tribe-events-has-events:after {
	background-color: {$colors['text']};
}
.tribe-events-calendar .mobile-active.tribe-events-has-events:after {
	background-color: {$colors['bg_color']};
}
#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a {
	color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a:hover {
	color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active,
#tribe-events-content .tribe-events-calendar td.mobile-active:hover {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active div[id*="tribe-events-daynum-"] {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar td.tribe-events-othermonth.mobile-active div[id*="tribe-events-daynum-"] a,
.tribe-events-calendar .mobile-active div[id*="tribe-events-daynum-"] a {
	background-color: transparent;
	color: {$colors['bg_color']};
}

/* Tooltip */
.recurring-info-tooltip,
.tribe-events-calendar .tribe-events-tooltip,
.tribe-events-week .tribe-events-tooltip,
.tribe-events-tooltip .tribe-events-arrow {
	color: {$colors['alter_text']};
	background: {$colors['alter_bg_color']};
}
#tribe-events-content .tribe-events-tooltip h3,
#tribe-events-content .tribe-events-tooltip h4 { 
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}
.tribe-events-tooltip .tribe-event-duration {
	color: {$colors['text_dark']};
}

/* Events list */
.tribe-events-list-separator-month {
	color: {$colors['text_dark']};
}
.tribe-events-list-separator-month:after {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .type-tribe_events + .type-tribe_events {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .tribe-events-event-cost span {
	color: {$colors['inverse_text']};
	border-color: {$colors['text_dark']};
	background: {$colors['text_dark']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a {
	color: {$colors['alter_link']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a:hover {
	color: {$colors['alter_hover']};
}
.tribe-mobile .tribe-events-list .tribe-events-venue-details {
	border-color: {$colors['alter_bd_color']};
}

/* Events day */
.tribe-events-day .tribe-events-day-time-slot h5 {
	color: {$colors['inverse_text']};
	background: {$colors['text_dark']};
}

/* Single Event */
.single-tribe_events .tribe-events-single-section {
	border-color: {$colors['bd_color']};
}
.single-tribe_events .tribe-events-venue-map {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_hover']};
	background: {$colors['alter_bg_hover']};
}
.single-tribe_events .tribe-events-schedule .tribe-events-cost {
	color: {$colors['text_dark']};
}

.tribe-events-calendar-day__event-datetime-wrapper,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-datetime-wrapper {
	color: {$colors['text_light']};
}
.tribe-events-calendar-list__event-date-tag-daynum.tribe-common-h5.tribe-common-h4--min-medium {
	color: {$colors['text_link']};
}
.tribe-events .datepicker .datepicker-switch {
	color: {$colors['text_link']};
}
.tribe-events .datepicker .datepicker-switch:hover {
	color: {$colors['text_hover']};
}
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__day:hover:after {
	background-color: {$colors['text_link']};
}
.tribe-common .tribe-common-b2 .tribe-events-c-messages__message-list-item .tribe-events-c-messages__message-list-item-link {
	color: {$colors['text_link']};
}
.tribe-common .tribe-common-b2 .tribe-events-c-messages__message-list-item .tribe-events-c-messages__message-list-item-link:hover {
	color: {$colors['text_hover']};
}
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next, 
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev {
	color: {$colors['text_link']};
}
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next:hover, 
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev:hover {
	color: {$colors['text_hover']};
}
.tribe-common .tribe-events-calendar-day__event-description.tribe-common-b2,
.tribe-events-calendar-month__calendar-event-tooltip-description.tribe-common-b3,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-description {
	color: {$colors['text']};
}


CSS;
		}
		
		return $css;
	}
}
?>