<?php
/**
 * The template for displaying Logo or Site name and slogan in the Header
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

// Site logo
$windsor_logo_image = '';
if (windsor_get_retina_multiplier(2) > 1)
	$windsor_logo_image = windsor_get_theme_option( 'logo_retina' );
if (empty($windsor_logo_image)) 
	$windsor_logo_image = windsor_get_theme_option( 'logo' );
$windsor_logo_text   = get_bloginfo( 'name' );
$windsor_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($windsor_logo_image) || !empty($windsor_logo_text)) {
	?><a class="logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($windsor_logo_image)) {
			$windsor_attr = windsor_getimagesize($windsor_logo_image);
			echo '<img src="'.esc_url($windsor_logo_image).'" class="logo_main" alt="' . esc_attr__('Logo', 'windsor') . '"'.(!empty($windsor_attr[3]) ? sprintf(' %s', $windsor_attr[3]) : '').'>' ;
		} else {
			windsor_show_layout($windsor_logo_text, '<span class="logo_text">', '</span>');
			windsor_show_layout($windsor_logo_slogan, '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>