<?php
/**
 * The template for displaying main menu
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */
$windsor_header_image = get_query_var('windsor_header_image');
?>
<div class="top_panel_fixed_wrap"></div>
<div class="top_panel_navi 
			<?php if ($windsor_header_image!='') echo ' with_bg_image'; ?>
			scheme_<?php echo esc_attr(windsor_is_inherit(windsor_get_theme_option('menu_scheme')) 
												? (windsor_is_inherit(windsor_get_theme_option('header_scheme')) 
													? windsor_get_theme_option('color_scheme') 
													: windsor_get_theme_option('header_scheme')) 
												: windsor_get_theme_option('menu_scheme')); ?>">
	<div class="menu_main_wrap clearfix">
		<div class="content_wrap">
			<?php
			// Logo
			get_template_part( 'templates/header-logo' );
			// Main menu
			?><nav class="menu_main_nav_area menu_hover_<?php echo esc_attr(windsor_get_theme_option('menu_hover')); ?>"><?php
				$windsor_windsor_menu_main = windsor_get_nav_menu('menu_main');
				if (empty($windsor_windsor_menu_main)) $windsor_windsor_menu_main = windsor_get_nav_menu();
				windsor_show_layout($windsor_windsor_menu_main);
				// Store menu layout for the mobile menu
				set_query_var('windsor_menu_main', $windsor_windsor_menu_main);
				// Display search field
				set_query_var('windsor_search_in_header', true);
				get_template_part( 'templates/search-field' );
			?></nav>
		</div>
	</div>
</div><!-- /.top_panel_navi -->