<?php
/**
 * The template for displaying Header widgets area
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

// Header sidebar
$windsor_header_name = windsor_get_theme_option('header_widgets');
$windsor_header_present = !windsor_is_off($windsor_header_name) && is_active_sidebar($windsor_header_name);
if ($windsor_header_present) {
	windsor_storage_set('current_sidebar', 'header');
	$windsor_header_wide = windsor_get_theme_option('header_wide');
	ob_start();
	do_action( 'windsor_action_before_sidebar' );
    if ( is_active_sidebar( $windsor_header_name ) ) {
        dynamic_sidebar( $windsor_header_name );
    }
	do_action( 'windsor_action_after_sidebar' );
	$windsor_widgets_output = ob_get_contents();
	ob_end_clean();
	$windsor_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $windsor_widgets_output);
	$windsor_need_columns = strpos($windsor_widgets_output, 'columns_wrap')===false;
	if ($windsor_need_columns) {
		$windsor_columns = max(0, (int) windsor_get_theme_option('header_columns'));
		if ($windsor_columns == 0) $windsor_columns = min(6, max(1, substr_count($windsor_widgets_output, '<aside ')));
		if ($windsor_columns > 1)
			$windsor_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($windsor_columns).' widget ', $windsor_widgets_output);
		else
			$windsor_need_columns = false;
	}
	?>
	<div class="header_widgets_wrap widget_area<?php echo !empty($windsor_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
		<div class="header_widgets_wrap_inner widget_area_inner">
			<?php
			if (!$windsor_header_wide) {
				?><div class="content_wrap"><?php
			}
			if ($windsor_need_columns) {
				?><div class="columns_wrap"><?php
			}
			windsor_show_layout($windsor_widgets_output);
			if ($windsor_need_columns) {
				?></div>	<!-- /.columns_wrap --><?php
			}
			if (!$windsor_header_wide) {
				?></div>	<!-- /.content_wrap --><?php
			}
			?>
		</div>	<!-- /.header_widgets_wrap_inner -->
	</div>	<!-- /.header_widgets_wrap -->
<?php
}
?>