<?php
/**
 * Generate custom CSS
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */


			
// Additional (calculated) theme-specific colors
// Attention! Don't forget setup custom colors also in the theme.customizer.color-scheme.js
if (!function_exists('windsor_customizer_add_theme_colors')) {
	function windsor_customizer_add_theme_colors($colors) {
		if (substr($colors['text'], 0, 1) == '#') {
			$colors['bg_color_0']  = windsor_hex2rgba( $colors['bg_color'], 0 );
			$colors['bg_color_02']  = windsor_hex2rgba( $colors['bg_color'], 0.2 );
			$colors['bg_color_07']  = windsor_hex2rgba( $colors['bg_color'], 0.7 );
			$colors['bg_color_08']  = windsor_hex2rgba( $colors['bg_color'], 0.8 );
			$colors['alter_bg_color_07']  = windsor_hex2rgba( $colors['alter_bg_color'], 0.7 );
			$colors['alter_bg_color_04']  = windsor_hex2rgba( $colors['alter_bg_color'], 0.4 );
			$colors['alter_bg_color_02']  = windsor_hex2rgba( $colors['alter_bg_color'], 0.2 );
			$colors['alter_bd_color_02']  = windsor_hex2rgba( $colors['alter_bd_color'], 0.2 );
			$colors['text_dark_07']  = windsor_hex2rgba( $colors['text_dark'], 0.7 );
			$colors['text_link_02']  = windsor_hex2rgba( $colors['text_link'], 0.2 );
			$colors['text_link_07']  = windsor_hex2rgba( $colors['text_link'], 0.7 );
		} else {
			$colors['bg_color_0'] = '{{ data.bg_color_0 }}';
			$colors['bg_color_02'] = '{{ data.bg_color_02 }}';
			$colors['bg_color_07'] = '{{ data.bg_color_07 }}';
			$colors['bg_color_08'] = '{{ data.bg_color_08 }}';
			$colors['alter_bg_color_07'] = '{{ data.alter_bg_color_07 }}';
			$colors['alter_bg_color_04'] = '{{ data.alter_bg_color_04 }}';
			$colors['alter_bg_color_02'] = '{{ data.alter_bg_color_02 }}';
			$colors['alter_bd_color_02'] = '{{ data.alter_bd_color_02 }}';
			$colors['text_dark_07'] = '{{ data.text_dark_07 }}';
			$colors['text_link_02'] = '{{ data.text_link_02 }}';
			$colors['text_link_07'] = '{{ data.text_link_07 }}';
		}
		return $colors;
	}
}



// Return CSS with custom colors and fonts
if (!function_exists('windsor_customizer_get_css')) {

	function windsor_customizer_get_css($colors=null, $fonts=null, $minify=true, $only_scheme='') {

		$css = array(
			'fonts' => '',
			'colors' => ''
		);
		
		// Prepare fonts
		if ($fonts === null)
			$fonts = windsor_get_theme_fonts();
		if ($fonts) {
			$tags = array('p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'link', 'info', 'menu', 'submenu', 'logo', 'slogan', 'button', 'input', 'decor');
			foreach ($tags as $tag) {
				if (!isset($fonts[$tag]))
					$fonts[$tag] = array( 'family' => 'inherit');
			}
			
			$rez = array();
			$rez['fonts'] = <<<CSS

body {	font-family: {$fonts['p']['family']}; }

h1,
h1 em{	font-family: {$fonts['h1']['family']};}
h2 {	font-family: {$fonts['h2']['family']};}
h3,
.post_title em{	font-family: {$fonts['h3']['family']};}
h4 {	font-family: {$fonts['h4']['family']};}
h5 {	font-family: {$fonts['h5']['family']};}
h6 {	font-family: {$fonts['h6']['family']};}

a {		font-family: {$fonts['link']['family']};}

input[type="text"],
input[type="number"],
input[type="email"],
input[type="tel"],
input[type="search"],
input[type="password"],
textarea,
textarea.wp-editor-area,
.select_container,
.select_container select {
	font-family: {$fonts['input']['family']};
}

.wp-block-button .wp-block-button__link,
button,
input[type="button"],
input[type="reset"],
input[type="submit"],
.theme_button,
.gallery_preview_show .post_readmore,
.more-link,
.windsor_tabs .windsor_tabs_titles li a {
	font-family: {$fonts['h5']['family']};
}

.rev_slider.theme_button,
rs-layer-wrap .theme_button {
	font-family: {$fonts['h5']['family']} !important;
}

em, i,
.post-date, .rss-date 
.post_date, .post_meta_item, .post_counters_item,
.comments_list_wrap .comment_date,
.comments_list_wrap .comment_time,
.comments_list_wrap .comment_counters {
	font-family: {$fonts['info']['family']};
}

.logo,
.logo_footer_text {
	font-family: {$fonts['logo']['family']};
}

.menu_footer_nav > li,
.menu_footer_nav > li > a,
.menu_main_nav > li,
.menu_main_nav > li > a,
.menu_header_nav > li,
.menu_header_nav > li > a,
.menu_mobile .menu_mobile_nav_area > ul > li,
.menu_mobile .menu_mobile_nav_area > ul > li > a {
	font-family: {$fonts['menu']['family']};
}
.menu_footer_nav > li li,
.menu_footer_nav > li li > a,
.menu_main_nav > li li,
.menu_main_nav > li li > a,
.menu_header_nav > li li,
.menu_header_nav > li li > a,
.menu_mobile .menu_mobile_nav_area > ul > li li,
.menu_mobile .menu_mobile_nav_area > ul > li li > a {
	font-family: {$fonts['submenu']['family']};
}

.top_panel .slider_engine_revo .slide_title,
 .content_wrap .slide_title{
	font-family: {$fonts['h1']['family']} !important;
}

blockquote,
mark, ins,
.logo_text,
.top_panel_title_2_text,
.post_price.price,
.theme_scroll_down {
	font-family: {$fonts['h5']['family']};
}

.logo_slogan,
fieldset legend,
blockquote a,
blockquote cite,
figure figcaption,
.wp-caption .wp-caption-text,
.wp-caption .wp-caption-dd,
.wp-caption-overlay .wp-caption .wp-caption-text,
.wp-caption-overlay .wp-caption .wp-caption-dd,
.format-audio .post_featured .post_audio_author,
.post_item_single .post_content .post_meta,
.author_bio .author_link,
.comments_list_wrap .comment_posted,
.comments_list_wrap .comment_reply {
	font-family: {$fonts['info']['family']};
}
rs-layer-wrap .slide_subtitle,
.top_panel rs-layer-wrap .slide_subtitle,
.top_panel .slider_engine_revo .slide_subtitle {
	font-family: {$fonts['info']['family']} !important;
}


CSS;
			$rez = apply_filters('windsor_filter_get_css', $rez, false, $fonts, false);
			$css['fonts'] = $rez['fonts'];
		}

		if ($colors !== false) {
			$schemes = empty($only_scheme) ? array_keys(windsor_get_list_schemes()) : array($only_scheme);
	
			if (count($schemes) > 0) {
				$rez = array();
				foreach ($schemes as $scheme) {
					// Prepare colors
					if (empty($only_scheme)) $colors = windsor_get_scheme_colors($scheme);
	
					// Make theme-specific colors and tints
					$colors = windsor_customizer_add_theme_colors($colors);
			
					// Make styles
					$rez['colors'] = <<<CSS

/* Common tags */
h1, h2, h3, h4, h5, h6,
h1 a, h2 a, h3 a, h4 a, h5 a, h6 a,
h1 a > *, h2 a > *, h3 a > *, h4 a > *, h5 a > *, h6 a > *,
.contant :not(.comments_list) li a {
	color: {$colors['text_dark']};
}
h1 a:hover, h2 a:hover, h3 a:hover, h4 a:hover, h5 a:hover, h6 a:hover,
h1 a:hover > *, h2 a:hover > *, h3 a:hover > *, h4 a:hover > *, h5 a:hover > *, h6 a:hover > *,
.contant :not(.comments_list) li a:hover {
	color: {$colors['text_link']};
}

dt, b, strong, i, em, mark, ins {	
	color: {$colors['text_dark']};
}
s, strike, del {	
	color: {$colors['text_light']};
}

a {
	color: {$colors['text_link']};
}
a:hover {
	color: {$colors['text_hover']};
}

blockquote, 
blockquote dt,
blockquote b,
blockquote strong,
blockquote i,
blockquote em,
blockquote mark,
blockquote ins {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
blockquote:before,
blockquote cite,
blockquote a {
	color: {$colors['text_link']};
}
blockquote a:hover {
	color: {$colors['bg_color']};
}

table th, table th + th, table td + th  {
	border-color: {$colors['bg_color_02']};
}
table td, table th + td, table td + td {
	color: {$colors['alter_dark']};
	border-color: {$colors['bg_color']};
}

table th {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}

table > tbody > tr:nth-child(2n+1) > td {
	background-color: {$colors['alter_bg_color_04']};
}

table > tbody > tr:nth-child(2n) > td {
	background-color: {$colors['alter_bg_color_02']};
}
table th a:hover {
	color: {$colors['bg_color']};
}

hr {
	border-color: {$colors['bd_color']};
}
figure figcaption,
.wp-caption .wp-caption-text,
.wp-caption .wp-caption-dd,
.wp-caption-overlay .wp-caption .wp-caption-text,
.wp-caption-overlay .wp-caption .wp-caption-dd {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
}
ul > li:before {
	color: {$colors['text_link']};
}


/* Form fields */
fieldset {
	border-color: {$colors['bd_color']};
}
fieldset legend {
	color: {$colors['text_dark']};
	background-color: {$colors['bg_color']};
}
input[type="text"],
input[type="number"],
input[type="email"],
input[type="tel"],
input[type="search"],
input[type="password"],
.widget_search form,
.select_container,
.select_container select,
.select_container option,
.select_container:before,
.select2-container .select2-choice,
.select2-container .select2-selection,
textarea,
textarea.wp-editor-area {
	color: {$colors['input_light']};
	border-color: {$colors['input_bd_color']};
	background-color: {$colors['input_bg_color']};
}
.select_container select {
	color: {$colors['input_light']};
}
input[type="text"]:focus,
input[type="number"]:focus,
input[type="email"]:focus,
input[type="tel"]:focus,
input[type="search"]:focus,
input[type="password"]:focus,
.select_container:hover,
.select_container:hover:before,
select:focus,
select option:hover,
select option:focus,
.select2-container .select2-choice:hover,
.select2-container .select2-selection:hover,
textarea:focus,
textarea.wp-editor-area:focus {
	color: {$colors['input_dark']};
	border-color: {$colors['input_bd_hover']};
	background-color: {$colors['input_bg_hover']};
}



.select_container select:focus {
	color: {$colors['input_dark']};
	border-color: {$colors['input_bd_hover']};
}
.select_container:after {
	color: {$colors['input_light']};
}
.select_container:hover:after {
	color: {$colors['input_dark']};
}
.widget_search form:hover:after {
	color: {$colors['input_dark']};
}
input::-webkit-input-placeholder,
textarea::-webkit-input-placeholder {
	color: {$colors['input_light']};
}
input[type="radio"] + label:before,
input[type="checkbox"] + label:before {
	border-color: {$colors['input_bd_color']};
	background-color: {$colors['input_bg_color']};
}
button,
input[type="reset"],
input[type="submit"],
input[type="button"] {
	background-color: {$colors['text_link']};
	color: {$colors['inverse_text']};
}
input[type="submit"]:hover,
input[type="reset"]:hover,
input[type="button"]:hover,
button:hover,
input[type="submit"]:focus,
input[type="reset"]:focus,
input[type="button"]:focus,
button:focus {
	background-color: {$colors['text_dark']};
	color: {$colors['bg_color']};
}
.wpcf7 input:focus,
.scheme_self .wpcf7 input:focus{
    color: {$colors['input_light']}!important;
}
#bbpress-forums div.bbp-the-content-wrapper input[type=button],
.wp-editor-container input[type="button"] {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bd_color']};
	color: {$colors['alter_dark']};
	-webkit-box-shadow: 0 1px 0 0 {$colors['alter_bd_hover']};
	   -moz-box-shadow: 0 1px 0 0 {$colors['alter_bd_hover']};
			box-shadow: 0 1px 0 0 {$colors['alter_bd_hover']};	
}
#bbpress-forums div.bbp-the-content-wrapper input[type=button]:hover,
#bbpress-forums div.bbp-the-content-wrapper input[type=button]:focus,
.wp-editor-container input[type="button"]:hover,
.wp-editor-container input[type="button"]:focus {
	background-color: {$colors['alter_bg_hover']};
	border-color: {$colors['alter_bd_hover']};
	color: {$colors['alter_link']};
}

.select2-results {
	color: {$colors['input_text']};
	border-color: {$colors['input_bd_hover']};
	background: {$colors['input_bg_color']};
}
.select2-results .select2-highlighted {
	color: {$colors['input_dark']};
	background: {$colors['input_bg_hover']};
}


/* WP Standard classes */
.sticky {
	border-color: {$colors['bd_color']};
}
.sticky .label_sticky {
	border-top-color: {$colors['text_link']};
}
	

/* Page */
body {
	color: {$colors['text']};
	background-color: {$colors['bg_color']};
}
#page_preloader,
.scheme_self.header_position_under .page_content_wrap,
.page_wrap {
	background-color: {$colors['bg_color']};
}
.preloader_wrap > div {
	background-color: {$colors['text_link']};
}

/* Header */
.scheme_self.top_panel.with_bg_image:before {
	background-color: {$colors['bg_color_07']};
}
.top_panel .slider_engine_revo .slide_subtitle {
	color: {$colors['text_link']};
}

/* Logo */
.logo b {
	color: {$colors['text_dark']};
}
.logo i {
	color: {$colors['text_link']};
}
.logo_text {
	color: {$colors['text_link']};
}
.logo:hover .logo_text {
	color: {$colors['text_dark']};
}
.logo_slogan {
	color: {$colors['text']};
}

/* Social items */
.socials_wrap .social_item a,
.socials_wrap .social_item a i {
	color: {$colors['text_light']};
}
.socials_wrap .social_item a:hover,
.socials_wrap .social_item a:hover i {
	color: {$colors['text_dark']};
}

/* Search */
.search_wrap .search_field {
	color: {$colors['text']};
}
.search_wrap .search_field:focus {
	color: {$colors['text_dark']};
}
.wp-block-search .wp-block-search__button:after,
.search_wrap .search_submit {
	color: {$colors['text_dark']};
}
.wp-block-search:hover .wp-block-search__button:after,
.search_wrap .search_submit:hover,
.search_wrap .search_submit:focus {
	color: {$colors['text']};
}

.post_item_none_search .search_wrap .search_submit:hover, .post_item_none_search .search_wrap .search_submit:focus,
.post_item_none_archive .search_wrap .search_submit:hover, .post_item_none_archive .search_wrap .search_submit:focus {
	color: {$colors['text_link']};
	background-color: transparent;
}


/* Search style 'Expand' */
.search_style_expand.search_opened {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bd_color']};
}
.search_style_expand.search_opened .search_submit {
	color: {$colors['text']};
}
.search_style_expand .search_submit:hover,
.search_style_expand .search_submit:focus {
	color: {$colors['text_dark']};
}

/* Search style 'Fullscreen' */
.search_style_fullscreen.search_opened .search_form_wrap {
	background-color: {$colors['bg_color_08']};
}
.search_style_fullscreen.search_opened .search_form {
	border-color: {$colors['text_dark']};
}
.search_style_fullscreen.search_opened .search_close,
.search_style_fullscreen.search_opened .search_field,
.search_style_fullscreen.search_opened .search_submit {
	color: {$colors['input_dark']};
}
.search_style_fullscreen.search_opened .search_close:hover,
.search_style_fullscreen.search_opened .search_field:hover,
.search_style_fullscreen.search_opened .search_field:focus,
.search_style_fullscreen.search_opened .search_submit:hover,
.search_style_fullscreen.search_opened .search_submit:focus {
	color: {$colors['input_text']};
}
.search_style_fullscreen.search_opened input::-webkit-input-placeholder {color:{$colors['input_light']}; opacity: 1;}
.search_style_fullscreen.search_opened input::-moz-placeholder          {color:{$colors['input_light']}; opacity: 1;}/* Firefox 19+ */
.search_style_fullscreen.search_opened input:-moz-placeholder           {color:{$colors['input_light']}; opacity: 1;}/* Firefox 18- */
.search_style_fullscreen.search_opened input:-ms-input-placeholder      {color:{$colors['input_light']}; opacity: 1;}

/* Search results */
.search_wrap .search_results {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bd_color']};
}
.search_wrap .search_results:after {
	background-color: {$colors['bg_color']};
	border-left-color: {$colors['bd_color']};
	border-top-color: {$colors['bd_color']};
}
.search_wrap .search_results .search_results_close {
	color: {$colors['text_light']};
}
.search_wrap .search_results .search_results_close:hover {
	color: {$colors['text_dark']};
}
.search_results.widget_area .post_item + .post_item {
	border-top-color: {$colors['bd_color']};
}


/* Main menu */
.menu_header_nav > li > a,
.menu_main_nav > li > a {
	color: {$colors['text_dark']};
}

.home:not(.top_panel_fixed) .top_panel_style_1 .top_panel_navi .menu_main_nav > li > a {
	color: {$colors['text_dark']};
}
.home:not(.top_panel_fixed) .top_panel_style_1 .top_panel_navi .menu_main_nav > li > a:hover {
	color: {$colors['text_link']};
}

.home:not(.top_panel_fixed) .top_panel_style_1 .top_panel_navi .menu_main_nav > li.current-menu-ancestor > a {
	color: {$colors['text_link']};
}

.menu_header_nav > li > a:hover,
.menu_header_nav > li.sfHover > a,
.menu_header_nav > li.current-menu-item > a,
.menu_header_nav > li.current-menu-parent > a,
.menu_header_nav > li.current-menu-ancestor > a,
.menu_main_nav > li > a:hover,
.menu_main_nav > li.sfHover > a,
.menu_main_nav > li.current-menu-item > a,
.menu_main_nav > li.current-menu-parent > a,
.menu_main_nav > li.current-menu-ancestor > a {
	color: {$colors['text_link']};
}

/* Submenu */
.menu_footer_nav > li ul {
	background-color: {$colors['bg_color']};
}
.menu_main_nav > li ul {
	background-color: {$colors['text_link']};
}
.menu_footer_nav > li li > a,
.menu_main_nav > li li > a {
	color: {$colors['inverse_link']};
}
.menu_footer_nav > li li > a:hover,
.menu_footer_nav > li li.sfHover > a {
	color: {$colors['text_link']};
}
.menu_main_nav > li li > a:hover,
.menu_main_nav > li li.sfHover > a {
	color: {$colors['inverse_hover']};
}
.menu_footer_nav > li li.current-menu-item > a,
.menu_footer_nav > li li.current-menu-parent > a,
.menu_footer_nav > li li.current-menu-ancestor > a,
.menu_main_nav > li li.current-menu-item > a,
.menu_main_nav > li li.current-menu-parent > a,
.menu_main_nav > li li.current-menu-ancestor > a {
	color: {$colors['inverse_hover']};
}
.top_panel_navi.state_fixed .menu_main_wrap {
	background-color: {$colors['bg_color']};
}

/* Mobile menu */
.scheme_self.menu_side_wrap .menu_side_button {
	color: {$colors['alter_dark']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color_07']};
}
.scheme_self.menu_side_wrap .menu_side_button:hover {
	color: {$colors['inverse_text']};
	border-color: {$colors['alter_hover']};
	background-color: {$colors['alter_link']};
}
> .menu_side_inner,
> .menu_mobile_inner {
	color: {$colors['alter_text']};
	background-color: {$colors['bg_color']};
}
.menu_mobile_button {
	color: {$colors['text_dark']};
}
.menu_mobile_button:hover {
	color: {$colors['text_link']};
}
> .menu_mobile_inner .menu_mobile_close:before,
> .menu_mobile_inner .menu_mobile_close:after {
	border-color: {$colors['alter_dark']};
}
> .menu_mobile_inner .menu_mobile_close:hover:before,
> .menu_mobile_inner .menu_mobile_close:hover:after {
	border-color: {$colors['alter_link']};
}
> .menu_mobile_inner a {
	color: {$colors['alter_dark']};
}
> .menu_mobile_inner a:hover,
> .menu_mobile_inner .current-menu-ancestor > a,
> .menu_mobile_inner .current-menu-item > a {
	color: {$colors['alter_link']};
}
> .menu_mobile_inner .search_mobile .search_submit {
	color: {$colors['input_light']};
}
> .menu_mobile_inner .search_mobile .search_submit:focus,
> .menu_mobile_inner .search_mobile .search_submit:hover {
	color: {$colors['input_dark']};
}

> .menu_mobile_inner .social_item a {
	color: {$colors['alter_link']};
}
> .menu_mobile_inner .social_item a:hover {
	color: {$colors['alter_dark']};
}

/* Page title and breadcrumbs */
.top_panel_title .post_meta {
	color: {$colors['text']};
}
.breadcrumbs {
	color: {$colors['text']};
}
.breadcrumbs a {
	color: {$colors['text_light']};
}
.breadcrumbs a:hover {
	color: {$colors['text_dark']};
}

/* Page image and text */
.top_panel_title_2_text {
	color: {$colors['text_dark']};
}


/* Tabs */
.windsor_tabs .windsor_tabs_titles li a {
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_bg_color']};
}
.windsor_tabs .windsor_tabs_titles li a:hover {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
.windsor_tabs .windsor_tabs_titles li.ui-state-active a {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}

/* Post layouts */
.post_item {
	color: {$colors['text']};
}
.post_meta,
.post_meta_item,
.post_meta_item a,
.post_meta_item:before,
.post_meta_item:hover:before,
.post_date a,
.post_date:before,
.post_info .post_info_item,
.post_info .post_info_item a,
.post_info_counters .post_counters_item,
.post_counters .socials_share .socials_caption:before,
.post_counters .socials_share .socials_caption:hover:before {
	color: {$colors['text_light']};
}
.post_date a:hover,
a.post_meta_item:hover,
.post_meta_item a:hover,
.post_info .post_info_item a:hover,
.post_info_counters .post_counters_item:hover {
	color: {$colors['text_dark']};
}

.post_item .post_title a:hover {
	color: {$colors['text_link']};
}

.post_meta_item.post_categories,
.post_meta_item.post_categories a {
	color: {$colors['text_link']};
}
.post_meta_item.post_categories a:hover {
	color: {$colors['text_hover']};
}

.post_meta_item .socials_share .social_items {
	background-color: {$colors['bg_color']};
}
.post_meta_item .social_items,
.post_meta_item .social_items:before {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bd_color']};
	color: {$colors['text_light']};
}

.post_layout_excerpt + .post_layout_excerpt {
	border-color: {$colors['bd_color']};
}
.post_layout_classic {
	border-color: {$colors['bd_color']};
}

.scheme_self.gallery_preview:before {
	background-color: {$colors['bg_color']};
}
.scheme_self.gallery_preview {
	color: {$colors['text']};
}

.post_featured:after {
	background-color: {$colors['bg_color']};
}

/* Post Formats */
.format-audio .post_featured .post_audio_author {
	color: {$colors['text_link']};
}
.format-audio .post_featured.without_thumb .post_audio {
	border-color: {$colors['bd_color']};
}
.format-audio .post_featured.without_thumb .post_audio_title,
.without_thumb .mejs-controls .mejs-currenttime,
.without_thumb .mejs-controls .mejs-duration {
	color: {$colors['text_dark']};
}

.mejs-controls .mejs-button,
.mejs-controls .mejs-time-rail .mejs-time-current,
.mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current {
	color: {$colors['inverse_text']};
	background: {$colors['text_link']};
}
.mejs-controls .mejs-button:hover {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']};
}
.mejs-controls .mejs-time-rail .mejs-time-total,
.mejs-controls .mejs-time-rail .mejs-time-loaded,
.mejs-container .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total {
	background: {$colors['text_link_02']};
}

.format-aside .post_content_inner {
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_bg_color']};
}

.format-link .post_content_inner,
.format-status .post_content_inner {
	color: {$colors['text_dark']};
}

.format-chat p > b,
.format-chat p > strong {
	color: {$colors['text_dark']};
}

.post_layout_chess .post_content_inner:after {
	background: linear-gradient(to top, {$colors['bg_color']} 0%, {$colors['bg_color_0']} 100%) no-repeat scroll right top / 100% 100% {$colors['bg_color_0']};
}
.post_layout_chess_1 .post_meta:before {
	background-color: {$colors['bd_color']};
}

/* Pagination */
.nav-links-old {
	color: {$colors['text_dark']};
}
.nav-links-old a:hover {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}

.page_links > a,
.comments_pagination .page-numbers,
.nav-links .page-numbers {
	color: {$colors['text_dark']};
	background-color: {$colors['input_bg_color']};
}
.page_links > a:hover,
.page_links > span:not(.page_links_title),
.comments_pagination a.page-numbers:hover,
.comments_pagination .page-numbers.current,
.nav-links a.page-numbers:hover,
.nav-links .page-numbers.current {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}

/* Single post */
.post_item_single .post_header .post_date {
	color: {$colors['text_light']};
}
.post_item_single .post_header .post_categories,
.post_item_single .post_header .post_categories a {
	color: {$colors['text_link']};
}
.post_item_single .post_header .post_meta_item,
.post_item_single .post_header .post_meta_item:before,
.post_item_single .post_header .post_meta_item:hover:before,
.post_item_single .post_header .post_meta_item a,
.post_item_single .post_header .post_meta_item a:before,
.post_item_single .post_header .post_meta_item a:hover:before,
.post_item_single .post_header .post_meta_item .socials_caption,
.post_item_single .post_header .post_meta_item .socials_caption:before,
.post_item_single .post_header .post_edit a {
	color: {$colors['text_light']};
}
.post_item_single .post_meta_item:hover,
.post_item_single .post_meta_item > a:hover,
.post_item_single .post_meta_item .socials_caption:hover,
.post_item_single .post_edit a:hover {
	color: {$colors['text_hover']};
}
.post_item_single .post_content .post_meta_label,
.post_item_single .post_content .post_meta_item:hover .post_meta_label {
	color: {$colors['text_dark']};
}
.post_item_single .post_content .post_tags,
.post_item_single .post_content .post_tags a {
	color: {$colors['text_link']};
}
.post_item_single .post_content .post_tags a:hover {
	color: {$colors['text_hover']};
}
.post_item_single .post_content .post_meta .post_share .social_item a {
	color: {$colors['inverse_text']} !important;
	background-color: {$colors['text_link']};
}
.post_item_single .post_content .post_meta .post_share .social_item a:hover {
	background-color: {$colors['text_hover']};
}

.post-password-form input[type="submit"] {
	border-color: {$colors['text_dark']};
}
.post-password-form input[type="submit"]:hover,
.post-password-form input[type="submit"]:focus {
	color: {$colors['bg_color']};
}

/* Single post navi */
.nav-links-single .nav-links {
	border-color: {$colors['bd_color']};
}
.nav-links-single .nav-links a .meta-nav {
	color: {$colors['text_light']};
}
.nav-links-single .nav-links a .post_date {
	color: {$colors['text_light']};
}
.nav-links-single .nav-links a:hover .meta-nav,
.nav-links-single .nav-links a:hover .post_date {
	color: {$colors['text_dark']};
}
.nav-links-single .nav-links a:hover .post-title {
	color: {$colors['text_link']};
}

/* Author info */
.scheme_self.author_info {
	color: {$colors['text']};
	background-color: {$colors['bg_color']};
}
.scheme_self.author_info .author_title {
	color: {$colors['text_link']};
}
.scheme_self.author_info a {
	color: {$colors['text_dark']};
}
.scheme_self.author_info a:hover {
	color: {$colors['text_link']};
}

/* Related posts */
.related_wrap {
	border-color: {$colors['bd_color']};
}
.related_wrap .related_item_style_1 .post_header {
	background-color: {$colors['bg_color_07']};
}
.related_wrap .related_item_style_1:hover .post_header {
	background-color: {$colors['bg_color']};
}
.related_wrap .related_item_style_1 .post_date a {
	color: {$colors['text']};
}
.related_wrap .related_item_style_1:hover .post_date a {
	color: {$colors['text_light']};
}
.related_wrap .related_item_style_1:hover .post_date a:hover {
	color: {$colors['text_dark']};
}

/* Comments */
.comments_list_wrap,
.comments_list_wrap > ul {
	border-color: {$colors['bd_color']};
}
.comments_list_wrap li + li,
.comments_list_wrap li ul {
	border-color: {$colors['bd_color']};
}
.comments_list_wrap .comment_info {
	color: {$colors['text_dark']};
}
.comments_list_wrap .comment_counters a {
	color: {$colors['text_link']};
}
.comments_list_wrap .comment_counters a:before {
	color: {$colors['text_link']};
}
.comments_list_wrap .comment_counters a:hover:before,
.comments_list_wrap .comment_counters a:hover {
	color: {$colors['text_hover']};
}
.comments_list_wrap .comment_text {
	color: {$colors['text']};
}
.comments_list_wrap .comment_reply a {
	color: {$colors['text_link']};
}
.comments_list_wrap .comment_reply a:hover {
	color: {$colors['text_hover']};
}
.comments_form_wrap {
	border-color: {$colors['bd_color']};
}
.comments_wrap .comments_notes {
	color: {$colors['text_light']};
}


/* Page 404 */
.post_item_404 .page_title {
	color: {$colors['text_light']};
}
.post_item_404 .page_description {
	color: {$colors['text_link']};
}
.post_item_404 .go_home {
	border-color: {$colors['text_dark']};
}

/* Sidebar */
.sidebar_inner {
	background-color: {$colors['alter_bg_color']};
	color: {$colors['alter_text']};
}
.sidebar_inner aside + aside {
	border-color: {$colors['alter_bd_color']};
}
.sidebar_inner h1, .sidebar_inner h2, .sidebar_inner h3, .sidebar_inner h4, .sidebar_inner h5, .sidebar_inner h6,
.sidebar_inner h1 a, .sidebar_inner h2 a, .sidebar_inner h3 a, .sidebar_inner h4 a, .sidebar_inner h5 a, .sidebar_inner h6 a {
	color: {$colors['alter_dark']};
}
.sidebar_inner h1 a:hover, .sidebar_inner h2 a:hover, .sidebar_inner h3 a:hover, .sidebar_inner h4 a:hover, .sidebar_inner h5 a:hover, .sidebar_inner h6 a:hover {
	color: {$colors['alter_link']};
}


/* Widgets */
aside {
	color: {$colors['alter_text']};
}
aside li:before {
	background-color: {$colors['alter_link']};
}
aside a {
	color: {$colors['alter_link']};
}
aside a:hover {
	color: {$colors['alter_hover']};
}
aside li > a {
	color: {$colors['alter_dark']};
}
aside li > a:hover {
	color: {$colors['alter_link']};
}

/* Archive */
.widget_archive li {
	color: {$colors['alter_dark']};
}

/* Calendar */

.widget_calendar caption,
.widget_calendar tbody td a,
.widget_calendar th {
	color: {$colors['alter_dark']};
}
.widget_calendar tbody td {
	color: {$colors['alter_text']} !important;
}
.widget_calendar tbody td a:hover {
	color: {$colors['alter_link']};
}
.widget_calendar tbody td a:after {
	background-color: {$colors['alter_link']};
}
.widget_calendar td#today {
	color: {$colors['inverse_text']} !important;
}
.widget_calendar td#today a {
	color: {$colors['inverse_link']};
}
.widget_calendar td#today a:hover {
	color: {$colors['inverse_hover']};
}
.widget_calendar td#today:before {
	background-color: {$colors['alter_link']};
}
.widget_calendar td#today a:after {
	background-color: {$colors['inverse_link']};
}
.widget_calendar td#today a:hover:after {
	background-color: {$colors['inverse_hover']};
}
.widget_calendar #prev a,
.widget_calendar #next a {
	color: {$colors['alter_link']};
}
.widget_calendar #prev a:hover,
.widget_calendar #next a:hover {
	color: {$colors['alter_hover']};
}
.wp-calendar-nav .wp-calendar-nav-prev a:before,
.wp-calendar-nav .wp-calendar-nav-next a:before,
.widget_calendar td#prev a:before,
.widget_calendar td#next a:before {
	background-color: {$colors['alter_bg_color']};
}
.content .wp-calendar-nav .wp-calendar-nav-prev a:before,
.content .wp-calendar-nav .wp-calendar-nav-next a:before{
    background-color: {$colors['bg_color']};
}


/* Categories */
.widget_categories li {
	color: {$colors['alter_dark']};
}

/* Tag cloud */
.widget_product_tag_cloud a,
.widget_tag_cloud a,
.wp-block-tag-cloud a{
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_bd_color']};
}
.widget_product_tag_cloud a:hover,
.widget_tag_cloud a:hover,
 .wp-block-tag-cloud a:hover{
	color: {$colors['inverse_text']} !important;
	background-color: {$colors['alter_link']};
}

/* RSS */
.widget_rss .widget_title a:first-child {
	color: {$colors['alter_link']};
}
.widget_rss .widget_title a:first-child:hover {
	color: {$colors['alter_hover']};
}
.widget_rss .rss-date {
	color: {$colors['alter_light']};
}

/* Footer */
.scheme_self.site_footer_wrap {
	background-color: {$colors['alter_bg_color']};
	color: {$colors['alter_text']};
}
.scheme_self.site_footer_wrap aside {
	border-color: {$colors['alter_bd_color']};
}
.scheme_self.site_footer_wrap h1, .scheme_self.site_footer_wrap h2, .scheme_self.site_footer_wrap h3, .scheme_self.site_footer_wrap h4, .scheme_self.site_footer_wrap h5, .scheme_self.site_footer_wrap h6,
.scheme_self.site_footer_wrap h1 a, .scheme_self.site_footer_wrap h2 a, .scheme_self.site_footer_wrap h3 a, .scheme_self.site_footer_wrap h4 a, .scheme_self.site_footer_wrap h5 a, .scheme_self.site_footer_wrap h6 a {
	color: {$colors['alter_dark']};
}
.scheme_self.site_footer_wrap h1 a:hover, .scheme_self.site_footer_wrap h2 a:hover, .scheme_self.site_footer_wrap h3 a:hover, .scheme_self.site_footer_wrap h4 a:hover, .scheme_self.site_footer_wrap h5 a:hover, .scheme_self.site_footer_wrap h6 a:hover {
	color: {$colors['alter_link']};
}
.logo_footer_wrap_inner {
	border-color: {$colors['alter_bd_color']};
}
.logo_footer_wrap_inner:after {
	background-color: {$colors['alter_text']};
}
.socials_footer_wrap_inner .social_item .social_icons {
	border-color: {$colors['alter_text']};
	color: {$colors['alter_text']};
}
.socials_footer_wrap_inner .social_item .social_icons:hover {
	border-color: {$colors['alter_dark']};
	color: {$colors['alter_dark']};
}
.menu_footer_nav_area ul li a {
	color: {$colors['alter_dark']};
}
.menu_footer_nav_area ul li a:hover {
	color: {$colors['alter_link']};
}
.menu_footer_nav_area ul li+li:before {
	border-color: {$colors['alter_light']};
}

.copyright_wrap_inner {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bd_color']};
	color: {$colors['text_dark']};
}
.copyright_wrap_inner a {
	color: {$colors['text_dark']};
}
.copyright_wrap_inner a:hover {
	color: {$colors['text_link']};
}
.copyright_wrap_inner .copyright_text {
	color: {$colors['text']};
}

/* Tooltipster */
.tooltipster-base.tooltipster-light .tooltipster-content {
	color: {$colors['inverse_dark']};
	background-color: {$colors['text_dark']};
}

 .tooltipster-base.tooltipster-light .tooltipster-arrow span {
 	border-top-color: {$colors['text_dark']} !important;
 }

/* Buttons */
.wp-block-button:not(.is-style-outline) .wp-block-button__link,
.theme_button,
.more-link,
.socials_share:not(.socials_type_drop) .social_icons,
.comments_wrap .form-submit input[type="submit"] {
	color: {$colors['inverse_text']} !important;
	background-color: {$colors['text_link']} !important;
}
.wp-block-button.is-style-outline .wp-block-button__link{
    color: {$colors['text_link']} !important;
	border-color: {$colors['text_link']} !important;
}
.wp-block-button:not(.is-style-outline) .wp-block-button__link:hover,
.theme_button:hover,
.more-link:hover,
.socials_share:not(.socials_type_drop) .social_icons:hover,
.comments_wrap .form-submit input[type="submit"]:hover,
.comments_wrap .form-submit input[type="submit"]:focus {
	color: {$colors['bg_color']} !important;
	background-color: {$colors['text_dark']} !important;
}
.wp-block-button.is-style-outline .wp-block-button__link:hover{
    color: {$colors['text_dark']} !important;
	border-color: {$colors['text_dark']} !important;
}

.format-video .post_featured.with_thumb .post_video_hover {
	color: {$colors['text_link']};
}
.format-video .post_featured.with_thumb .post_video_hover:hover {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}

.theme_scroll_down:hover {
	color: {$colors['text_link']};
}

/* Third-party plugins */

.mfp-bg {
	background-color: {$colors['bg_color_07']};
}
.mfp-image-holder .mfp-close,
.mfp-iframe-holder .mfp-close {
	color: {$colors['text_dark']};
}
.mfp-image-holder .mfp-close:hover,
.mfp-iframe-holder .mfp-close:hover {
	color: {$colors['text_link']};
}

button[disabled],
input[type="submit"][disabled],
input[type="button"][disabled] {
    background-color: {$colors['text_light']} !important;
    color: {$colors['text']} !important;
	background-image: none !important;
}

CSS;
				
					$rez = apply_filters('windsor_filter_get_css', $rez, $colors, false, $scheme);
					$css['colors'] .= $rez['colors'];
				}
			}
		}
				
		$css_str = (!empty($css['fonts']) ? $css['fonts'] : '')
					. (!empty($css['colors']) ? $css['colors'] : '');
		return $minify ? windsor_minify_css($css_str) : $css_str;
	}
}
?>